/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/include/Timer.hh
 * General Sound Manipulation Program is Copyright (C) 2000 - 2007
 *   Valentin Ziegler and René Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */

/* Short Description:
 *   Some basic timer classes.
 */

#ifndef UTILITY__TIMER_HH__
#define UTILITY__TIMER_HH__

#include <sys/time.h> // used by Timer
#include <sys/times.h> // used by TickTimer

#include <inttypes.h>

#include <iostream>
#include <string>

namespace Utility
{
  class Timer
  {
  public:
    Timer ();
    
    void Reset ();
    uint64_t Delta ();
    uint64_t PerSecond ();
    
    uint64_t Value ();

    const char* Unit () { return "us"; }
    
  private:
    timeval m_start;
  };
  
  class TickTimer
  {
  public:
    TickTimer ();
    
    void Reset ();
    uint64_t Delta ();
    uint64_t PerSecond ();
    
    uint64_t Value ();
    
    const char* Unit () { return "us"; }
    
  private:
    struct tms m_times;
  };
  
  class TimebaseTimer
  {
  public:
    TimebaseTimer ();
    
    void Reset ();
    uint64_t Delta ();
    uint64_t PerSecond ();
    
    uint64_t Value ();

    const char* Unit () { return "cycles"; }
    
  private:
    uint64_t start_tick;
  };

  template <typename T>
  class AutoTimer
  {
  public:
    AutoTimer (const std::string& i_text) {
      m_text = i_text;
    }
    ~AutoTimer () {
      std::cout << ">> AutoTimer: \"" << m_text
		<< "\" took: " << m_timer.Delta () << " " << m_timer.Unit () << std::endl;
    }
    
    uint64_t Delta () {
      return m_timer.Delta ();
    }
    uint64_t PerSecond () {
      return m_timer.PerSecond ();
    }
    
  private:
    T m_timer;
    std::string m_text;
  };
  
} // end namespace utility

#endif // UTILITY__TIMER_HH__
