# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: package/.../runit/rocknet_runit.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---
export CANUSESERVICE=1

service_create() {
	local service_name=$1 runstring="$2" finishstring="$3"

	mkdir -p $rocknet_tmp_base/$service_name/log

	# ./run
	cat <<-EOT > $rocknet_tmp_base/$service_name/run
	#!/bin/sh
	exec 2>&1

	$runstring
	EOT

	# ./log/run
	cat <<-EOT > $rocknet_tmp_base/$service_name/log/run
	#!/bin/sh
	exec 2>&1

	if [ ! -d /var/log/$service_name ]; then
	    mkdir -p /var/log/$service_name
	    chown log /var/log/$service_name
	fi
	exec chpst -ulog svlogd -tt /var/log/$service_name
	EOT

	# ./finish
	if [ "$finishstring" ]; then
		cat <<-EOT > $rocknet_tmp_base/$service_name/finish
		#!/bin/sh
		exec 2>&1

		$finishstring
		EOT
		chmod +x $rocknet_tmp_base/$service_name/finish
	fi
        
	chmod +x $rocknet_tmp_base/$service_name/{,log/}run
	ln -nfs $rocknet_tmp_base/$service_name/ /service/$service_name
}

service_destroy() {
	local service_name=$1 x=

	for x in . log; do
		if [ -d /service/$service_name/$x/supervise ]; then
        		runsvctrl d /service/$service_name/$x
        		svwaitdown /service/$service_name/$x
		fi
	done

	rm -f /service/$service_name
	rm -rf $rocknet_tmp_base/$service_name/
}
