/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: pcm/include/Types.hh
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and Ren Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */

/* Short Description:
 *   Advanced templates to perform automated type convertion for
 *   various kind of integer and floating point types. Convertions for
 *   the same type are entirely optimized away - and integer convertions
 *   are "normally" optimized down to a single shift instruction - of
 *   course fully inlined.
 */

#ifndef LOWLEVEL__ENDIANESS_HH__
#define LOWLEVEL__ENDIANESS_HH__

#include <sys/types.h>
#include <endian.h>
#include <byteswap.h>

#include <math.h>

#include <limits>

namespace Utility {
  
  class EndianessTraits {
  public:
    
    static const bool IsSpecialized = false;
    static const bool HasEndianess = false;
    static const bool IsBigendian = false;
  };

  class LittleEndianessTraits : public EndianessTraits {
  public:
  
    static const bool IsSpecialized = true;
    static const bool HasEndianess = true;
    static const bool IsBigendian = false;
  };

  class BigEndianessTraits : public EndianessTraits {
  public:
  
    static const bool IsSpecialized = true;
    static const bool HasEndianess = true;
    static const bool IsBigendian = true;
  };

#if defined __BIG_ENDIAN__ || defined _BIG_ENDIAN
  typedef BigEndianessTraits HostEndianessTraits;
#else
  typedef LittleEndianessTraits HostEndianessTraits;
#endif
  
  typedef BigEndianessTraits NetworkEndianessTraits;
  
#endif // LOWLEVEL__ENDIANESS_HH__
