#!/bin/bash
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: package/.../bashcompletion/usr_bin_bashcomp.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2004 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

if [ -z "$*" ]
then
	. /etc/bash_completion
	complete | sed "s, -F \([^ ]*\), -C '$0 \1',"

	tmpfile=$( mktemp $HOME/.bashcomp.XXXXXXXXXX )
	declare -f > $tmpfile
	mv $tmpfile $HOME/.bashcomp.cache
else
	# Have: COMP_LINE COMP_POINT
	# Need: COMP_CWORD COMP_WORDS

	COMP_WORDS=( $COMP_LINE )
	remain=( ${COMP_LINE:COMP_POINT} )
	COMP_CWORD=$(( ${#COMP_WORDS[@]} - ${#remain[@]} ))

	ch="${COMP_LINE:COMP_POINT-1:1}"
	[ -z "${ch//[ 	]/}" ] || (( COMP_CWORD = COMP_CWORD - 1 ))

	shopt -s extglob
	. $HOME/.bashcomp.cache

	"$@" # run the completion function
	for x in "${COMPREPLY[@]}"; do echo "$x"; done
fi

