#!/bin/sh
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: misc/archive/apply-patch.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

basedirs="Documentation|architecture|misc|package|scripts|target";
error=0

for patch in "$@"
do
	plevel=1
	for plevelc in 2 0 1
	do
		if egrep -q "^--- ([^/]*/){$plevelc}($basedirs)" $patch; then
		plevel=$plevelc
	fi
	done
	echo
	echo "*** patch -fp$plevel --dry-run < $patch"
	patch -fp$plevel --dry-run < $patch || error=1
done

if [ $error = 1 ]; then
	echo
	echo "*** Dry run returned errors."
	echo
	exit 1
fi

echo
read -p 'Press ENTER to apply the patches or Ctrl-C to abort: '
echo

for patch in "$@"
do
	plevel=1
	for plevelc in 2 0 1
	do
		if egrep -q "^--- ([^/]*/){$plevelc}($basedirs)" $patch; then
			plevel=$plevelc
		fi
	done
	echo "*** patch -fp$plevel < $patch"
	patch -fp$plevel <$patch
	echo
done

